@extends(template().'layouts.app')
@section('title',$page_title)
@section('content')

    <section class="login-register-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-6 col-lg-7 col-md-9">
                    <div class="login-register-form">
                        <form action="{{ route('user.smsVerify') }}" method="post">
                            @csrf

                            <div class="section-header">
                                <h3>@lang('Phone Number Verify Here!')</h3>
                                <div class="description">@lang('Validate your phone number effortlessly for enhanced account protection. Verification made simple, security assured.')</div>
                            </div>
                            <div class="row g-4">
                                <div class="col-12">
                                    <input type="text" name="code" value="{{ old('code') }}"
                                           class="form-control"
                                           id="exampleInputEmail1"
                                           placeholder="@lang('Code')">
                                    @error('code')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>

                            </div>
                            <button type="submit" class="cmn-btn mt-30 w-100">
                                <span>@lang('Submit')</span>
                            </button>
                        </form>
                        @if (Route::has('user.resendCode'))
                            <div class="col-12 resendCode">
                                <div class="form-check d-flex justify-content-between flex-wrap gap-2">
                                    <div class="forgot highlight">
                                        <a href="{{route('user.resendCode')}}?type=phone">@lang('Resend code')</a>
                                        @error('resend')
                                        <p class="text-danger mt-1">@lang($message)</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@push('style')
    <style>
        .resendCode{
            padding: 20px 0 0 0;
        }
        .resendCode .forgot.highlight{
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 100%;
        }
    </style>
@endpush
@push('script')
    <script>
        @if($errors->any())
            @foreach($errors->all() as $error)
                Notiflix.Notify.failure("{{ $error }}");
            @endforeach
        @endif
    </script>
@endpush

